<?php
date_default_timezone_set('America/Lima');
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$hora = date("g:i:s A");
$fecha = date("d/m/y");

require __DIR__ . '/autoload.php';
require __DIR__ . '/config.php';

use Mike42\Escpos\Printer;
//use Mike42\Escpos\EscposImage;
//use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;
//use Mike42\Escpos\PrintConnectors\FilePrintConnector;

/*[OBTENEMOS LA IP DE LA IMPRESORA DE COCINA]*/
$ip_printer = '127.0.0.1';
$url = SISTEMA . "informe/listado_impresoras";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data_impresoras = json_decode($response, true);
foreach ($data_impresoras as $row_imp) {
	if($row_imp['nombre']=='COCINA'){ $ip_printer = $row_imp['ip']; }
}

echo $ip_printer;

$data = json_decode($_GET['data'],true);

/*
$img = imagecreatefromjpeg('resources/pipi.jpg');
$new_img = imagecreatetruecolor(imagesx($img), imagesy($img));
imagealphablending($new_img, false);
imagesavealpha($new_img, true);
$transparent = imagecolorallocatealpha($new_img, 255, 255, 255, 127);
imagefilledrectangle($new_img, 0, 0, imagesx($img), imagesy($img), $transparent);
imagecopy($new_img, $img, 0, 0, 0, 0, imagesx($img), imagesy($img));
$path = 'resources/new_image.png';
imagepng($new_img, $path);
*/

//$connector = new WindowsPrintConnector("smb://".$data['nombre_pc']."/".$data['nombre_imp']);
//$connector = new NetworkPrintConnector("192.168.31.230");
$connector = new NetworkPrintConnector($ip_printer); 
//$connector = new FilePrintConnector("php://stdout");

$printer = new Printer($connector);

try {
	//$logo = EscposImage::load("resources/pipi.jpg", false);
    //$printer -> setJustification(Printer::JUSTIFY_CENTER);
    //$printer -> graphics($logo);
	//bitImage
	//bitImageColumnFormat
    //$printer -> feed();

  	$printer -> setJustification(Printer::JUSTIFY_CENTER);
	
	if($data['codigo_anulacion'] == 1){
		$printer -> setTextSize(2,2);
		$printer -> text("***************\n");
		$printer -> text("ANULADO\n");
		$printer -> text("***************\n");
		$printer -> selectPrintMode();
	}
		
	if($data['pedido_tipo'] == 1){
		$printer -> text("======================================\n");
		$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
		$printer -> text("MESA\n");
	}elseif($data['pedido_tipo'] == 2){
		$printer -> text("======================================\n");
		$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
		$printer -> text("MOSTRADOR\n");
	}elseif($data['pedido_tipo'] == 3){
		$printer -> text("======================================\n");
		$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
		$printer -> text("DELIVERY\n");
	}
	
	if($data['codigo_anulacion'] <> 1){
		$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
		$printer -> text("Comanda #".$data['correlativo_imp']."\n");
		$printer -> selectPrintMode();
		$printer -> text("======================================\n");
	}
	
	$printer -> setJustification(Printer::JUSTIFY_RIGHT);
	$printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
	$printer -> text("".$fecha." - ".$hora."\n");
	if($data['pedido_tipo'] == 1){
		$printer -> text($data['pedido_numero']." - ".$data['pedido_cliente']."\n");
		$printer -> text("MOZO:".$data['pedido_mozo']."\n");
	}elseif($data['pedido_tipo'] == 2){
		$printer -> text("LLEVAR #".$data['pedido_numero']." - CLIENTE:".$data['pedido_cliente']."\n");
	}elseif($data['pedido_tipo'] == 3){
		$printer -> text("DELIVERY #".$data['pedido_numero']." - CLIENTE:".$data['pedido_cliente']."\n");
	}
	$printer -> setJustification(Printer::JUSTIFY_CENTER);
	$printer -> text("________________________\n");
	$printer -> text("\n");
	$printer -> setJustification(Printer::JUSTIFY_LEFT);
	foreach ($data['items'] as $value) {
		$printer -> setEmphasis(true);
		$printer -> text($value['cantidad']." ".$value['producto']." | ".$value['presentacion']."\n");
		$printer -> text(" *".$value['comentario']."\n");
	}
	
	/*
	$testStr = "20609383438|03|BI01|00003266|0.00|2.00|2023-04-14|1|00000000|EpGVN+P4flXmxRgjCPbVQjSw+ybBcsDzhARLRjfyy8M=";
	$printer -> qrCode($testStr, Printer::QR_ECLEVEL_H);
	//$printer -> text("Most simple example\n");
	$printer -> feed();
	*/
	$printer -> setJustification(Printer::JUSTIFY_CENTER);
	$printer -> text("________________________\n");
	$printer -> text("************************\n");
	$printer -> text("\n");
	$printer -> cut();
	$printer -> close();

} catch(Exception $e) {
	echo "No se pudo imprimir en esta impresora " . $e -> getMessage() . "\n";
}

?>
echo "<script lenguaje="JavaScript">window.close();</script>";

